﻿#include  "StdAfx.h"

#include  <szWindows.hpp>
#include  <szCodecManager.hpp>
#include  <szRuntimeException.hpp>
#include  <buffers.hpp>

#ifdef _WIN32
HINSTANCE g_hInstance;
#endif

SZ_NS_BEG(szpp)

SZ_SPEC
void OnClientStartup(HMODULE hModule)
{
  g_hInstance = hModule;
}

SZ_SPEC
void OnClientShutdown()
{
  CodecManager::Shutdown();
}

SZ_SPEC
szstring GetClientModuleFileName()
{
  sbuf<szchar, MAX_PATH> buf;
  if (0 == GetModuleFileName(g_hInstance, buf, buf.size()))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get module file name")) << last_error_info(GetLastError()));
  return szstring(buf);
}

SZ_NS_END(szpp)
